import pandas as pd  
from sklearn.preprocessing import LabelEncoder 
import pickle 
from decision_company import read_csv_file, df_copy, encoder_instance, encode_column, corr, avg, fetch_column, bind_dataframe

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create a copy of the stable_employment DataFrame  
stable_employment_encoded = df_copy(stable_employment)  
  
# Initialize the label encoder  
encoder = encoder_instance()  
  
# Convert non-numeric columns to numeric values using label encoding 
for column in stable_employment_encoded.columns:    
    if stable_employment_encoded[column].dtype == 'object':    
        stable_employment_encoded[column] = encode_column(encoder, stable_employment_encoded[column])   
  
# Calculate the correlation matrix for the encoded dataset  
correlation_matrix = corr(stable_employment_encoded)  
  
# Analyze the relationships between variables  
credit_history_duration_relationship = avg(fetch_column(bind_dataframe(stable_employment, 'credit_history'), 'duration'))  
employment_duration_relationship = avg(fetch_column(bind_dataframe(stable_employment, 'employment'), 'duration')) 

# Print the correlation matrix  
print("Correlation matrix:\n", correlation_matrix)  
pickle.dump(correlation_matrix,open("./ref_result/correlation_matrix.pkl","wb"))
  
# Print the relationships between variables  
print("\nRelationship between credit history and loan duration:\n", credit_history_duration_relationship)  
pickle.dump(credit_history_duration_relationship,open("./ref_result/credit_history_duration_relationship.pkl","wb"))
print("\nRelationship between employment status and loan duration:\n", employment_duration_relationship)  
pickle.dump(employment_duration_relationship,open("./ref_result/employment_duration_relationship.pkl","wb"))
  
# Note: You may want to further explore the relationships between other variables or visualize the data using plots to gain more insights. 



